/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.mixin.entity;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import noppes.npcs.CustomNpcs;
import noppes.npcs.api.mixin.entity.IEntityLivingBaseMixin;
import noppes.npcs.entity.EntityNPCInterface;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityLivingBase.class}, priority=499)
public class EntityLivingBaseMixin
implements IEntityLivingBaseMixin {
    @Final
    @Shadow
    protected static DataParameter<Byte> field_184621_as;
    @Mutable
    @Shadow
    private DamageSource field_189750_bF;
    @Mutable
    @Shadow
    private long field_189751_bG;
    @Shadow
    protected float field_110153_bc;
    @Mutable
    @Shadow
    protected int field_70718_bc;
    @Mutable
    @Shadow
    protected double field_184626_bk;
    @Mutable
    @Shadow
    protected double field_70709_bj;
    @Unique
    protected Random nps$rand = new Random();
    @Unique
    private DamageSource npcs$currentDamageSource;

    @Inject(method={"attackEntityFrom"}, at={@At(value="HEAD")})
    private void npcs$saveDamageSource(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        this.npcs$currentDamageSource = source;
    }

    @Inject(method={"knockBack"}, at={@At(value="HEAD")}, cancellable=true)
    private void npcs$knockBack(Entity entityIn, float strength, double xRatio, double zRatio, CallbackInfo ci) {
        EntityLivingBase parent = (EntityLivingBase)this;
        strength = this.npcs$currentDamageSource != null && !this.npcs$currentDamageSource.func_94541_c() && this.npcs$currentDamageSource.func_76352_a() ? (strength *= 0.375f) : (strength *= 0.5f);
        LivingKnockBackEvent event = ForgeHooks.onLivingKnockBack((EntityLivingBase)parent, (Entity)entityIn, (float)(strength *= (float)CustomNpcs.KnockBackBasePower / 100.0f), (double)xRatio, (double)zRatio);
        if (event.isCanceled()) {
            return;
        }
        strength = event.getStrength();
        xRatio = event.getRatioX();
        zRatio = event.getRatioZ();
        if (this.nps$rand.nextDouble() >= parent.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e()) {
            parent.field_70160_al = true;
            double f = MathHelper.func_76133_a((double)(xRatio * xRatio + zRatio * zRatio));
            parent.field_70159_w /= 2.0;
            parent.field_70179_y /= 2.0;
            parent.field_70159_w -= xRatio / f * (double)strength;
            parent.field_70179_y -= zRatio / f * (double)strength;
            if (parent.field_70122_E) {
                parent.field_70181_x /= 2.0;
                parent.field_70181_x += (double)strength;
                if (parent.field_70181_x > (double)0.4f) {
                    parent.field_70181_x = 0.4f;
                }
            }
        }
        this.npcs$currentDamageSource = null;
        ci.cancel();
    }

    @Redirect(method={"attackEntityFrom"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/EntityLivingBase;knockBack(Lnet/minecraft/entity/Entity;FDD)V"))
    private void npcs$attackEntityFrom(EntityLivingBase instance, Entity entity, float strength, double xRatio, double zRatio) {
        if (entity instanceof EntityNPCInterface) {
            float f1;
            float f0;
            EntityNPCInterface npc = (EntityNPCInterface)entity;
            if (this.npcs$currentDamageSource.func_76352_a()) {
                f0 = 0.25f;
                f1 = 0.15f * (float)npc.stats.ranged.getKnockback();
            } else {
                f0 = 0.2f;
                f1 = 0.2f * (float)npc.stats.melee.getKnockback();
            }
            strength = f1 == 0.0f ? 0.0f : f0 + f1;
        }
        if (strength != 0.0f) {
            ((EntityLivingBase)this).func_70653_a(entity, strength, xRatio, zRatio);
        }
    }

    @Inject(method={"canEntityBeSeen"}, at={@At(value="HEAD")})
    public void npcs$canEntityBeSeen(Entity entityIn, CallbackInfoReturnable<Boolean> cir) {
    }

    @Override
    public void npcs$setLastDamageSource(DamageSource newDamageSource) {
        this.field_189750_bF = newDamageSource;
    }

    @Override
    public void npcs$setLastDamageStamp(long newLastDamageStamp) {
        this.field_189751_bG = newLastDamageStamp;
    }

    @Override
    public float npcs$getLastDamage() {
        return this.field_110153_bc;
    }

    @Override
    public void npcs$setRecentlyHit(int newRecentlyHit) {
        if (newRecentlyHit < 0) {
            newRecentlyHit *= -1;
        }
        this.field_70718_bc = newRecentlyHit;
    }

    @Override
    public void npcs$setInterpTargetYaw(double newInterpTargetYaw) {
        this.field_184626_bk = newInterpTargetYaw;
    }

    @Override
    public void npcs$setInterpTargetPitch(double newInterpTargetPitch) {
        this.field_70709_bj = newInterpTargetPitch;
    }

    @Override
    public void npcs$setCurrentDamageSource(DamageSource source) {
        this.npcs$currentDamageSource = source;
    }

    @Override
    public DataParameter<Byte> npcs$getHandStates() {
        return field_184621_as;
    }
}

